select   daten.Bezeichnung,
         daten.Kuerzel,
         daten.Vorgangskennzeichen,
         
         sum(daten.Stichtag1) as "Stichtag 31.12. vor 5 Jahren",
         sum(daten.Stichtag2) as "Stichtag 31.12. vor 4 Jahren",
         sum(daten.Stichtag3) as "Stichtag 31.12. vor 3 Jahren",
         sum(daten.Stichtag4) as "Stichtag 31.12. vor 2 Jahren",
         sum(daten.Stichtag5) as "Stichtag 31.12. vor 1 Jahr"
         
from     ( 

         select   'Basiszahl 3 und 3.4' as "Bezeichnung",
                  isnull(k.kennzeichen,'(ohne)') as "Kuerzel",
                  isnull(k.bezeichnung,'(ohne)') as "Vorgangskennzeichen",

                  count(distinct(case when m.vondatum <= cast('31.12.' + cast(year(getdate())-5 as char(4)) as datetime) and s.berichtsjahr = year(getdate())-5
                                      and (m.bisdatum >= cast('31.12.' + cast(year(getdate())-5 as char(4)) as datetime) or m.bisdatum is null) 
                                      and s.freigegeben = '1'
                                      then h.massnahme else null end)) as "Stichtag1",
                             
                  count(distinct(case when m.vondatum <= cast('31.12.' + cast(year(getdate())-4 as char(4)) as datetime) and s.berichtsjahr = year(getdate())-4
                                      and (m.bisdatum >= cast('31.12.' + cast(year(getdate())-4 as char(4)) as datetime) or m.bisdatum is null)
                                      and s.freigegeben = '1' 
                                      then h.massnahme else null end)) as "Stichtag2",
                             
                  count(distinct(case when m.vondatum <= cast('31.12.' + cast(year(getdate())-3 as char(4)) as datetime) and s.berichtsjahr = year(getdate())-3
                                      and (m.bisdatum >= cast('31.12.' + cast(year(getdate())-3 as char(4)) as datetime) or m.bisdatum is null) 
                                      and s.freigegeben = '1'
                                      then h.massnahme else null end)) as "Stichtag3",   
                             
                  count(distinct(case when m.vondatum <= cast('31.12.' + cast(year(getdate())-2 as char(4)) as datetime) and s.berichtsjahr = year(getdate())-2
                                      and (m.bisdatum >= cast('31.12.' + cast(year(getdate())-2 as char(4)) as datetime) or m.bisdatum is null)
                                      and s.freigegeben = '1'
                                      then h.massnahme else null end)) as "Stichtag4",
                             
                  count(distinct(case when m.vondatum <= cast('31.12.' + cast(year(getdate())-1 as char(4)) as datetime) and s.berichtsjahr = year(getdate())-1
                                      and (m.bisdatum >= cast('31.12.' + cast(year(getdate())-1 as char(4)) as datetime) or m.bisdatum is null) 
                                      and s.freigegeben = '1'
                                      then h.massnahme else null end)) as "Stichtag5"                                                                                                                                               

         from     n_vorgang v inner join n_vorgmassnahme h on v.vorgangsnummer = h.vorgang
                              inner join n_hzestatistik s on h.massnahme = s.massnahmennummer
                              inner join n_massnahme m on h.massnahme = m.massnahmennummer
                              left join n_kennz k on v.kennz_fk = k.lfdnr
                              
        where     s.artderhilfe in ('04','05','06','07','08','09','10','11','12','14','15','16')
        
        and       s.hilfedauertjahrese = '1'
        and       s.freigegeben = '1'

        group by  isnull(k.kennzeichen,'(ohne)'),
                  isnull(k.bezeichnung,'(ohne)')

         ) as daten
         
group by daten.Bezeichnung,
         daten.Kuerzel,
         daten.Vorgangskennzeichen

order by daten.Bezeichnung,
         daten.Kuerzel,
         daten.Vorgangskennzeichen